/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package college;

import java.util.GregorianCalendar;

/**
 * This class defines a Person object.
 * ASSIGNMENT2 PART 2 adds the Comparable interface
 * @author Daryle Niedermayer I.S.P., PMP
 * @version 1.0 2008/05/05 
 */

public class Person implements Dateable, Comparable {
    
    private String nationalID;
    private String firstName;
    private String lastName;
    private String address;
    private String mobileNumber;
    private String homeNumber;
    private String workNumber;
    private char gender;
    private int birthYear;


    /** Creates a new instance of Person
     * Default constructor
     */
    public Person() {}

    /** Creates a new instance of Person 
     * 
     @param nationalID The person's National ID number
     */
    public Person(String nationalID) {
        this.nationalID = nationalID;
    }
    
    /** Creates a new instance of Person
     * 
     * @param firstName The person's first name
     * @param lastName The person's last name
     */
    public Person(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
    }
    
 /** Creates a new instance of Person
  * 
  * @param nationalID The person's National ID number
  * @param firstName The person's first name
  * @param lastName The person's last name
  */   
    public Person(String nationalID, String firstName, String lastName) {
        this.nationalID = nationalID;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    /** Accessor method gets the instance's NationalID string
     * 
     * @return nationalID
     */
    public String getNationalID(){
        return this.nationalID;
    }
    
    /**
     * Mutator method to set the instance's National ID string
     * @param nationalID 
     */
    public void setNationalID(String nationalID) {
        this.nationalID = nationalID;
    }

    /** Accessor method gets the instance's First Name string
     * 
     * @return firstName
     */
    public String getFirstName(){
        return this.firstName;
    }

        /**
     * Mutator method to set the instance's National ID string
         * @param firstName 
         */
     public void setFirstName(String firstName) {
         this.firstName = firstName;
     }
    
    /** Accessor method gets the instance's Last Name string
     * 
     * @return lastName
     */

    public String getLastName(){
        return this.lastName;
    }
    
    /** Mutator method to set lastName
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** Accessor method gets the instance's Address string
     * 
     * @return address
     */
    public String getAddress(){
        return this.address;
    }

    /** Mutator method to set the instance's Address
     * 
     * @param address 
     */
    public void setAddress(String address) {
        this.address = address;
    }   

    /** Accessor method gets the instance's Mobile Number
     * 
     * @return mobileNumber
     */
    public String getMobileNumber(){
        return this.mobileNumber;
    }

    /** Mutator method to set the instance's Mobile Number
     * 
     * @param mobileNumber 
     */
    public void setMobileNumber(String mobileNumber){
        this.mobileNumber = mobileNumber;
    }

    /** Accessor method gets the instance's Home Number
     * 
     * @return homeNumber
     */
    public String getHomeNumber(){
        return this.homeNumber;
    }

    /** Mutator method to set the instance's Home Number
     * 
     * @param homeNumber 
     */
    public void setHomeNumber(String homeNumber){
        this.homeNumber = homeNumber;
    }

    /** Accessor method gets the instance's Work Number
     * 
     * @return workNumber
     */
    public String getWorkNumber(){
        return this.workNumber;
    }

    /** Mutator method sets the instance's Work Number
     * 
     * @param workNumber
     */
    public void setWorkNumber(String workNumber){
        this.workNumber = workNumber;
    }
    
    /** Accessor method gets the instance's gender
     * 
     * @return gender
     */    
    public char getGender() {
        return gender;
    }

    /** Mutator method sets the instance's gender to one of 'F' or 'M'
     * 
     * @param gender Can be of the value 'f','F','m', or 'M'. Values
     *        will be converted to uppercase.
     * @throws java.lang.Exception If value is an invalid gender, sets gender
     *        to a sentinel value of '-' before throwing the exception.
     */
    public void setGender(char gender) throws Exception {
        if (gender == 'm') {gender = 'M';}
        if (gender == 'f') {gender = 'F';}
        if (gender != 'M' || gender != 'F') {
            gender = '-';
            throw new Exception("Gender value invalid: " + new Character(gender).toString());
        }
    } 

    /** Accessor method gets the instance's Date of Birth
     * 
     * @return dateofbirth
     */
    public int getDateOfBirth() {
        return birthYear;
    }
    
    /** Mutator method sets the instance's Date of Birth
     * 
     * @param year
     * @param month
     * @param day
     */
    public void setDateOfBirth(int year) {
        this.birthYear = year;
    }
    
    /**
     * Returns the calendar age of the person from today.
     * THIS IS ASSIGNMENT 1, PART 2
     * @return
     */
    public Double getAge() {
        return new Double((new GregorianCalendar().get(GregorianCalendar.YEAR))-this.birthYear);
    }

    /**
     * ASSIGNMENT 2 PART 2
     * This method compares two people's names alphabetically. If the lastname (surname)
     * of the supplied person is less than "this", then a -1 is returned.
     * If it is more, then a +1 is returned.
     * If they are the same lastname, then the firstnames are compared using the
     * same tests.
     * If both names are identical, a 0 is returned.
     * @param arg0 Should be a Person object
     * @return int
     * @throws ClassCastException 
     */
    public int compareTo(Object arg0) throws ClassCastException {
        if (!(arg0.getClass().getName().equals("college.Person") ||
                arg0.getClass().getSuperclass().getName().equals("college.Person"))) {
            throw new ClassCastException("Not a person! Class is a " 
                   + arg0.getClass().getName() );
        }
        else {
            Person p = (Person)arg0;
            int test = this.getLastName().compareTo(p.getLastName());
            if (test < 0) { return -1; }
            else if (test > 0) { return 1; }
                
            else {
                test = this.getFirstName().compareTo(p.getFirstName());
                if (test < 0) {return -1;}
                else if (test > 0) {return 1;}
                else return 0;
            }
            
        }
    }
    
}
